"use strict";

describe("ContextModule.State", function() {

    var serializedStates = {
            "empty": {
                "musicCollectionGrid": {
                    "entityConfigs": [],
                    "viewConfigs": [],
                },
                "musicRecordingGrid": {
                    "entityConfigs": [],
                    "viewConfigs": [],
                }
            },

            "empty_faulty1": {
                
            },
            "empty_faulty2": 42,
            "empty_faulty3": null,
            
            "empty_incomplete1": {
                "musicCollectionGrid": {
                    "entityConfigs": [],
                    "viewConfigs": [],
                },
            },
            "empty_incomplete2": {
                "musicRecordingGrid": {
                    "viewConfigs": [],
                },
            },

            "1by1": {
                "musicCollectionGrid": {
                    "entityConfigs": [{clientId: "c10", parameters: {"ce": 1}, plannedParameterUpdates: {}}],
                    "viewConfigs": [{clientId: "c20", parameters: {"cv": 2}, plannedParameterUpdates: {}}],
                },
                "musicRecordingGrid": {
                    "entityConfigs": [{clientId: "c30", parameters: {"re": 3}, plannedParameterUpdates: {}}],
                    "viewConfigs": [{clientId: "c40", parameters: {"rv": 4}, plannedParameterUpdates: {}}],
                }
            },
            "1by1_faulty1": {
                "musicCollectionGrid": {
                    "entityConfigs": [{clientId: "c10", parameters: {"ce": 1}, plannedParameterUpdates: null}],
                    "viewConfigs": [{clientId: "c20", parameters: {"cv": 2}, plannedParameterUpdates: {}}],
                },
                "musicRecordingGrid": {
                    "entityConfigs": [{clientId: "c30", parameters: {"re": 3}, plannedParameterUpdates: 42}],
                    "viewConfigs": [{clientId: "c40", parameters: {"rv": 4}, plannedParameterUpdates: {}}],
                }
            },
            "1by1_incomplete1": {
                "musicCollectionGrid": {
                    "entityConfigs": [{clientId: "c10", parameters: {"ce": 1}, }],
                    "viewConfigs": [{clientId: "c20", parameters: {"cv": 2}, plannedParameterUpdates: {}}],
                },
                "musicRecordingGrid": {
                    "entityConfigs": [{clientId: "c30", parameters: {"re": 3}, }],
                    "viewConfigs": [{clientId: "c40", parameters: {"rv": 4}, plannedParameterUpdates: {}}],
                }
            },
            
    };
    
    it("is promptly created", function() {
        var testedState = new App.ContextModule.State();
        
        expect(testedState).not.toBe(null);
        
        expect(testedState.get("musicCollectionGrid")).not.toBe(null);
        expect(testedState.get("musicCollectionGrid") instanceof App.ContextModule.ConfigGrid).toBe(true);

        expect(testedState.get("musicRecordingGrid")).not.toBe(null);
        expect(testedState.get("musicRecordingGrid") instanceof App.ContextModule.ConfigGrid).toBe(true);
        
    });

    it("serializes and unserializes itself", function() {
        var testedState = new App.ContextModule.State();
        
        testedState.unserialize(serializedStates["empty"]);
        expect(testedState.serialize()).toEqual(serializedStates["empty"]);
        
        testedState.unserialize(serializedStates["empty_faulty1"]);
        expect(testedState.serialize()).toEqual(serializedStates["empty"]);
        
        testedState.unserialize(serializedStates["empty_faulty2"]);
        expect(testedState.serialize()).toEqual(serializedStates["empty"]);
        
        testedState.unserialize(serializedStates["empty_faulty3"]);
        expect(testedState.serialize()).toEqual(serializedStates["empty"]);
        
        testedState.unserialize(serializedStates["empty_incomplete1"]);
        expect(testedState.serialize()).toEqual(serializedStates["empty"]);

        testedState.unserialize(serializedStates["empty_incomplete2"]);
        expect(testedState.serialize()).toEqual(serializedStates["empty"]);
        
        testedState.unserialize(serializedStates["1by1"]);
        expect(testedState.serialize()).toEqual(serializedStates["1by1"]);

        testedState.unserialize(serializedStates["1by1_faulty1"]);
        expect(testedState.serialize()).toEqual(serializedStates["1by1"]);

        testedState.unserialize(serializedStates["1by1_incomplete1"]);
        expect(testedState.serialize()).toEqual(serializedStates["1by1"]);
    });
    
    xit("returns grid by type", function() {
        
    });
    
    xit("works with property musicRecordingsGridIsShown", function() {
        
    });
    
    it("triggers change event when when config grids change", function() {
        var testedState = new App.ContextModule.State();
        
        var changeListener = jasmine.createSpy("changeListener");
        testedState.on("change", changeListener);
        
        expect(changeListener.calls.count()).toEqual(0);
        
        testedState.get("musicCollectionGrid").entityConfigs.add(new App.ContextModule.Config());
        expect(changeListener.calls.count()).toEqual(1);
        changeListener.calls.reset();

        testedState.get("musicRecordingGrid").entityConfigs.add(new App.ContextModule.Config());
        expect(changeListener.calls.count()).toEqual(1);
        changeListener.calls.reset();
        
        testedState.unserialize(serializedStates["empty"]);
        expect(changeListener.calls.count()).toEqual(1);
        changeListener.calls.reset();

        testedState.unserialize(serializedStates["empty_faulty1"]);
        expect(changeListener.calls.count()).toEqual(0);
        changeListener.calls.reset();

        testedState.unserialize(serializedStates["empty_incomplete1"]);
        expect(changeListener.calls.count()).toEqual(0);
        changeListener.calls.reset();

        testedState.unserialize(serializedStates["1by1"]);
        expect(changeListener.calls.count()).toEqual(1);
        changeListener.calls.reset();
        testedState.unserialize(serializedStates["1by1"]);
        expect(changeListener.calls.count()).toEqual(0);
        changeListener.calls.reset();
        testedState.unserialize(serializedStates["1by1_incomplete1"]);
        expect(changeListener.calls.count()).toEqual(0);
        changeListener.calls.reset();
    });
});
